const float sunPathRotation = -35;
const int shadowMapResolution = 2048; // [512 768 1024 1536 2048 3172 4096 8192 16384]
const float shadowDistance = 160.0;   // [64.0 80.0 96.0 112.0 128.0 144.0 160.0 176.0 192.0 208.0 224.0 240.0 256.0 272.0 288.0 304.0 320.0 336.0 352.0 384.0 400.0 416.0 432.0 448.0 464.0 480.0 496.0 512.0]
const float shaddist = shadowDistance;
#ifdef DISTANT_HORIZONS
    #ifdef DH_ALT_SHADOWS
const float shadowNearPlane = 0.05;
const float shadowFarPlane = 2048.0;
    #endif
#endif

#define SHADOW_OFFSET 0.03

#ifndef DISTANT_HORIZONS
const float shadowDistanceRenderMul = 1;
#else
const float shadowDistanceRenderMul = -1;
#endif
const bool shadowHardwareFiltering = true;
const float ambientOcclusionLevel = 1.0;

#define PENUMBRA_SHADOWS
#define RSM

#if !defined MC_GL_VENDOR_NVIDIA && !defined MC_OS_WINDOWS
    #undef PENUMBRA_SHADOWS
#endif

#define SHADOW_DISTORTION 75

#ifdef DISTANT_HORIZONS

    #ifdef DH_SHADOWMAP

float calcDistortMainDH(vec2 worldpos)
{

    float a = exp(0.1);
    float b = exp(1.0) - a;
        // Simplified linear interpolation for range [0,1]
        #ifndef SHADOW_CULLING

    return 0.4 + length(worldpos);
        #endif
    return log(length(worldpos) * b + a) * (350 / shadowDistance);
}
    #else

float computeValue(float x)
{
    const float a = 0.325;
    const float b = 0.3;
    return a * (log(x) / 2.302585) + b;
}

float calcDistortMainDH(vec2 worldpos)
{
    // Simplified linear interpolation for range [0,1]
    return DISTORTION_ADJUSTMENT + length(worldpos) * (computeValue(min(shadowDistance, far)) - DISTORTION_ADJUSTMENT);
}

    #endif
#else
float computeValue(float x)
{
    const float a = 0.325;
    const float b = 0.3;
    return a * (log(x) / 2.302585) + b;
}

float calcDistortMainDH2(vec2 worldpos)
{
    // Simplified linear interpolation for range [0,1]
    return DISTORTION_ADJUSTMENT + length(worldpos) * (computeValue(min(shadowDistance, far)) - DISTORTION_ADJUSTMENT);
}

float calcDistortMainDH(vec2 worldpos)
{
    // === Global shadow radius input ===
    const float shadowDist = shadowDistance; // in blocks (same as shadow map range)

    const float BOOST = 0.1;        // Extra distortion at low ranges
    const float DECAY = 1.0 / 96.0; // Controls falloff rate
    const float BASE = 1.0;         // Minimum value (used at max range)
    const float MARGIN = 1.0;       // Global scale multiplier

    // === Log warp coefficients (range compression) ===
    const float warpStart = 1.105171;             // Lower bound (~0.1)
    const float warpScale = 2.718282 - warpStart; // Upper bound (~1.0) minus start

    // === Final warped output ===
    return log(length(worldpos) * warpScale + warpStart) * ((BOOST * exp(-DECAY * shadowDist) + BASE) * MARGIN);
}

#endif

// Function to calculate distortion based on world position
float calcDistort(vec2 worldpos)
{
    return 1.0 / calcDistortMainDH(abs(worldpos.xy));
}

// Function to calculate shadow distortion
vec2 calcShadowDistortion(vec3 shadowpos)
{

    return shadowpos.xy / calcDistortMainDH(abs(shadowpos.xy));
}
